/*------------------------------------------------------------------------------*
 *	File Name: 	MSMath.h	     												*
 *	Purpose:	Math function prototypes for calling standard C functions		*
 *				in msvcrt.dll and etc.											*
 *  Creation:	April 12, 2001 by CPY											* 
 *  	Copyright (c) OriginLab Corp. 2001, 2002, 2003							*
 *		All Rights Reserved														*
 *	Modification log        													*
 *------------------------------------------------------------------------------*/  
#ifndef _MSMATH_H
#define _MSMATH_H


// Origin C specific command to include an external DLL
// All function declarations will be for the importdll
// until another importdll is specified or when the end
// of the header file is reached
#pragma dll(msvcrt, system)

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:abs_(global_function)
*/
int		abs(int n); // Returns the absolute value of an integer.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:atan_(global_function)
*/
double	atan(double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:atan2_(global_function)
*/
double	atan2(double y, double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:cos_(global_function)
*/
double	cos(double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:sin_(global_function)
*/
double	sin(double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tanh_(global_function)
*/
double	tanh(double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:J0_(lowcase)_(global_function)
*/
double	_j0(double x);			  

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:J1_(lowcase)_(global_function)
*/
double	_j1(double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Jn_(lowcase)_(global_function)
*/
double	_jn(int n, double x);
										 
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Y0_(lowcase)_(global_function)
*/
double	_y0(double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:y1_(lowcase)_(global_function)
*/
double	_y1(double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Yn_(lowcase)_(global_function)
*/
double	_yn(int n, double x);
//------------------

// Maximum value that can be returned by the rand function.
#define RAND_MAX 0x7fff

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:rand_(global_function)
*/
int     rand();

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:srand_(global_function)
*/
void    srand(unsigned int n);

#endif  //_MSMATH_H

